topic "SFtp";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,2#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[{_} 
[ {{10000@(113.42.0) [s0;%% [*@7;4 SFtp]]}}&]
[s0; &]
[s1;:Upp`:`:SFtp`:`:class: [@(0.0.255)3 class][3 _][*3 SFtp][3 _:_][@(0.0.255)3 public][3 _][*@3;3 S
sh`::Subsystem]&]
[s2;# [%% This class encapsulates the SFTP subsystem. It allows for 
a range of operations on remote files, such as file/directory 
creation, deletion, renaming, file transfers, directory listings 
etc. See also ][%%^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:class^ Ssh][%% , 
][%%^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:class^ Ssh`::Subsy
stem][%% , ][%%^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:class^ J
obQueue].&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Method List]]}}&]
[s3;%% &]
[s5;:Upp`:`:SFtp`:`:Handle`(Upp`:`:SFtpHandle`*`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&]_[* H
andle]([_^Upp`:`:SFtpHandle^ SFtpHandle][@(0.0.255) `*]_[*@3 hndl])&]
[s2;%% Attaches a libssh2 handle to the given SFtp instance. [%-*@3 hndl] 
must be a valid libssh2 handle. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:GetSession`(`)const: [_^Upp`:`:SFtpSession^ SFtpSession][@(0.0.255) `*
]_[* GetSession]()_[@(0.0.255) const]&]
[s2;%% Returns the libssh2 sftp session handle on success, NULL on 
failure. Session handle is taken care of internally.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:GetHandle`(`)const: [_^Upp`:`:SFtpHandle^ SFtpHandle][@(0.0.255) `*]_
[* GetHandle]()_[@(0.0.255) const]&]
[s2;%% Returns the active libssh2 sftp file handle on success, NULL 
on failure.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Open`(const Upp`:`:String`&`,unsigned long`,long`): [@(0.0.255) boo
l]_[* Open]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[@(0.0.255) unsigned]_[@(0.0.255) long]_[*@3 flags], [@(0.0.255) long]_[*@3 mode])&]
[s2;%% Opens the remote file or directory at [%-*@3 path] with access 
[%-*@3 flags] and [%-*@3 mode], and sets the active file handle to 
operate on. Returns true on success. File handles allocated with 
this method must be released using [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Close`(`)^ C
lose() ]method. This method is blocking.&]
[s2; &]
[s2;%% Filesystem access [%-*@3 flags] :&]
[s7;i1440;a17;:Ctrl`:`:CENTER:~~~.1728;%% [%-*C@3 READ]-|Opens file 
in read mode.&]
[s7;i1440;a17;:Ctrl`:`:LEFT:~~~.1728~1728;%% [%-*C@3 WRITE]-|Opens file 
in write mode.&]
[s7;i1440;a17;:Ctrl`:`:RIGHT:~~~.1728~1728;%% [%-*C@3 APPEND]-|Opens 
file in append mode.&]
[s7;i1440;a17;:Ctrl`:`:TOP:~~~.1728~1728;%% [%-*C@3 CREATE]-|Creates 
file if it doesn`'t exist.&]
[s7;i1440;~~~.1728~1728;%% [%-*C@3 EXCLUSIVE]-|Opens file in exclusive 
access mode.&]
[s7;i1440;a17;:Ctrl`:`:BOTTOM:~~~.1728~1728;%% [%-*C@3 TRUNCATE]-|Opens 
file and truncates it to zero (0).&]
[s3;%% &]
[s2;%% Filesystem access [%-*@3 mode]s (permissions):&]
[s7;i1440;~~~.1728~1440~1440~1440;%% [*C@3 IRUSR, IWUSR, IXUSR, IRWXU]-|User 
permissions.&]
[s7;i1440;~~~.1728;%% [%-*C@3 IRGRP, IWGRP, IXGRP, IRWXG]-|Group permissions&]
[s7;i1440;~~~.1728;%% [%-*C@3 IROTH, IWOTH, IXOTH, IRWXO]-|Permissions 
for others.&]
[s7;i1440;~~~.1728;%% [%-*C@3 RWXA]-|Unrestricted access for all.&]
[s0;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartOpen`(const Upp`:`:String`&`,unsigned long`,long`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartOpen]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 path], [@(0.0.255) unsigned]_[@(0.0.255) long]_[*@3 flags], [@(0.0.255) long]_[*@3 mod
e])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Open`(const Upp`:`:String`&`,unsigned long`,long`)^ O
pen()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Close`(`): [@(0.0.255) bool]_[* Close]()&]
[s2;%% Closes the active file handle. Return true on success. File 
handles allocated with [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Open`(const Upp`:`:String`&`,unsigned long`,long`)^ O
pen()] method must be released using this method. This method 
is blocking.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartClose`(`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&]_[* StartClose]()&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Close`(`)^ C
lose()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Remove`(const Upp`:`:String`&`): [@(0.0.255) bool]_[* Remove]([@(0.0.255) c
onst]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path])&]
[s2;%% Deletes a file at [%-*@3 path]. Returns true on success. This 
method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartRemove`(const Upp`:`:String`&`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&
]_[* StartRemove]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Close`(`)^ R
emove()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Rename`(const Upp`:`:String`&`,const Upp`:`:String`&`): [@(0.0.255) b
ool]_[* Rename]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 oldpath], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 newpath])&]
[s2;%% Renames a file or directory from [%-*@3 oldpath] to [%-*@3 newpath]. 
Returns true on success. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartRename`(const Upp`:`:String`&`,const Upp`:`:String`&`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartRename]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 oldpath], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 newpath])
&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Rename`(const Upp`:`:String`&`,const Upp`:`:String`&`)^ R
ename()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:SetStat`(const Upp`:`:SFtpAttrs`&`): [@(0.0.255) bool]_[* SetStat]([@(0.0.255) c
onst]_[_^Upp`:`:SFtpAttrs^ SFtpAttrs][@(0.0.255) `&]_[*@3 attrs])&]
[s2;%% Sets the attributes of the active file. Returns true on success. 
This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartSetStat`(const Upp`:`:SFtpAttrs`&`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&
]_[* StartSetStat]([@(0.0.255) const]_[_^Upp`:`:SFtpAttrs^ SFtpAttrs][@(0.0.255) `&]_[*@3 a
ttrs])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:SetStat`(const Upp`:`:SFtpAttrs`&`)^ S
etStat()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:GetStat`(Upp`:`:SFtpAttrs`&`): [@(0.0.255) bool]_[* GetStat]([_^Upp`:`:SFtpAttrs^ S
FtpAttrs][@(0.0.255) `&]_[*@3 attrs])&]
[s2;%% Gets the attributes of the active file. Returns true on success. 
This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartGetStat`(Upp`:`:SFtpAttrs`&`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&
]_[* StartGetStat]([_^Upp`:`:SFtpAttrs^ SFtpAttrs][@(0.0.255) `&]_[*@3 attrs])&]
[s2;%%  Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:GetStat`(Upp`:`:SFtpAttrs`&`)^ G
etStat()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining..&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Sync`(`): [@(0.0.255) bool]_[* Sync]()&]
[s2;%% Synchronizes the active file to the remote disk. Returns true 
on success. This method is blocking.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartSync`(`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&]_[* StartSync]()&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Sync`(`)^ S
ync()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:OpenDir`(const Upp`:`:String`&`): [@(0.0.255) bool]_[* OpenDir]([@(0.0.255) c
onst]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path])&]
[s2;%% Opens a directory at [%-*@3 path]. File handles allocated with 
this method must be released using [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Close`(`)^ C
lose() ]method. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartOpenDir`(const Upp`:`:String`&`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&
]_[* StartOpenDir]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:OpenDir`(const Upp`:`:String`&`)^ O
penDir()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:GetDir`(`)const: [_^Upp`:`:String^ String]_[* GetDir]()_[@(0.0.255) con
st]&]
[s2;%% Returns the active directory path on success, and an empty 
string on failure.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:ListDir`(Upp`:`:SFtp`:`:DirList`&`,Upp`:`:Gate`<Upp`:`:SFtp`:`:DirEntry`&`>`): [@(0.0.255) b
ool]_[* ListDir]([_^Upp`:`:SFtp`:`:DirList^ SFtp`::DirList][@(0.0.255) `&]_[*@3 list], 
[_^Upp`:`:Gate^ Gate]<DirEntry[@(0.0.255) `&]>_[*@3 progress]_`=_Null)&]
[s2;%% Retrieves a directory [%-*@3 list]ing of for the active file 
handle. Returns true on success. This method will return true 
even when the remote directory is empty. [%-*@3 progress] function 
can be used to track progress of the operation, and to get the 
directory entries one by one; returning true will cancel the 
operation. Note that the file handle must be already allocated 
using [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:OpenDir`(const Upp`:`:String`&`)^ O
penDir()] method, and it must be released using [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Close`(`)^ C
lose()] method afterwards. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartListDir`(Upp`:`:SFtp`:`:DirList`&`,Upp`:`:Gate`<Upp`:`:SFtp`:`:DirEntry`&`>`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartListDir]([_^Upp`:`:SFtp`:`:DirList^ DirList][@(0.0.255) `&]_[*@3 l
ist], [_^Upp`:`:Gate^ Gate]<DirEntry[@(0.0.255) `&]>_[*@3 progress]_`=_Null)&]
[s2;%% Asynchronous variant of the [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:ListDir`(const Upp`:`:String`&`,Upp`:`:SFtp`:`:DirList`&`,Upp`:`:Gate`<Upp`:`:SFtp`:`:DirEntry`&`>`)^ L
istDir()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:ListDir`(const Upp`:`:String`&`,Upp`:`:SFtp`:`:DirList`&`,Upp`:`:Gate`<Upp`:`:SFtp`:`:DirEntry`&`>`): [@(0.0.255) b
ool]_[* ListDir]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[_^Upp`:`:SFtp`:`:DirList^ DirList][@(0.0.255) `&]_[*@3 list], [_^Upp`:`:Gate^ Gate]<DirE
ntry[@(0.0.255) `&]>_[*@3 progress]_`=_Null)&]
[s2;%% Overload. Retrieves a directory [%-*@3 list]ing of [%-*@3 path]. 
Returns true on success. This method will return true even when 
the remote directory is empty. [%-*@3 progress] function can be 
used to track progress of the operation, and to get the directory 
entries one by one; returning true will cancel the operation. 
Note that this overload manages (opens and closes) file handle 
internally. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartListDir`(const Upp`:`:String`&`,Upp`:`:SFtp`:`:DirList`&`,Upp`:`:Gate`<Upp`:`:SFtp`:`:DirEntry`&`>`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartListDir]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 path], [_^Upp`:`:SFtp`:`:DirList^ DirList][@(0.0.255) `&]_[*@3 list], 
[_^Upp`:`:Gate^ Gate]<DirEntry[@(0.0.255) `&]>_[*@3 progress]_`=_Null)&]
[s2;%% Asynchronous variant of the [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:StartListDir`(Upp`:`:SFtp`:`:DirList`&`,Upp`:`:Gate`<Upp`:`:SFtp`:`:DirEntry`&`>`)^ L
istDir()] overload. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining..&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:MakeDir`(const Upp`:`:String`&`,long`): [@(0.0.255) bool]_[* MakeDir](
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[@(0.0.255) long]_[*@3 mode])&]
[s2;%% Creates a directory at [%-*@3 path] with access [%-*@3 mode]. 
Returns true on success. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartMakeDir`(const Upp`:`:String`&`,long`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&
]_[* StartMakeDir]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[@(0.0.255) long]_[*@3 mode])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:MakeDir`(const Upp`:`:String`&`,long`)^ M
akeDir()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:RemoveDir`(const Upp`:`:String`&`): [@(0.0.255) bool]_[* RemoveDir]([@(0.0.255) c
onst]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path])&]
[s2;%% Deletes a remote directory at [%-*@3 path]. Return true on success. 
This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartRemoveDir`(const Upp`:`:String`&`): [_^Upp`:`:SFtp^ SFtp][@(0.0.255) `&
]_[* StartRemoveDir]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path])
&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:RemoveDir`(const Upp`:`:String`&`)^ R
emoveDir()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:MakeLink`(const Upp`:`:String`&`,const Upp`:`:String`&`): [@(0.0.255) b
ool]_[* MakeLink]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 orig], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 link])&]
[s2;%% Creates a symbolic [%-*@3 link] for the filesystem objects pointed 
at path [%-*@3 orig]. Returns true on success. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartMakeLink`(const Upp`:`:String`&`,const Upp`:`:String`&`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartMakeLink]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 orig], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 link])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:MakeLink`(const Upp`:`:String`&`,const Upp`:`:String`&`)^ M
akeLink()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining..&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:ReadLink`(const Upp`:`:String`&`,Upp`:`:String`&`): [@(0.0.255) boo
l]_[* ReadLink]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 target])&]
[s2;%% Resolves a symbolic link file system object at [%-*@3 path ]to 
its next [%-*@3 target]. Returns true on success. This method is 
blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartReadLink`(const Upp`:`:String`&`,Upp`:`:String`&`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartReadLink]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 path], [_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 target])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:ReadLink`(const Upp`:`:String`&`,Upp`:`:String`&`)^ R
eadLink()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:RealPath`(const Upp`:`:String`&`,Upp`:`:String`&`): [@(0.0.255) boo
l]_[* RealPath]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 target])&]
[s2;%% Resolves a complex, relative, or symlinked file [%-*@3 path] 
to its effective [%-*@3 target]. Returns true on success. This 
method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartRealPath`(const Upp`:`:String`&`,Upp`:`:String`&`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartRealPath]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 path], [_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 target])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:RealPath`(const Upp`:`:String`&`,Upp`:`:String`&`)^ R
ealPath()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Put`(const Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [@(0.0.255) b
ool]_[* Put]([@(0.0.255) const]_[_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 in], 
[_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], [_^Upp`:`:int64^ int64]>_[*@3 progress]_`=
_Null)&]
[s2;%% Uploads the local data at [%-*@3 in] to remote file designated 
by the active file handle. Returns true on success. [%-*@3 progress 
]function can be used to track the progress of the upload; returning 
true will abort the operation. Note that the file handle must 
be already allocated using [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Open`(const Upp`:`:String`&`,unsigned long`,long`)^ O
pen()] method, and it must be released using [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Close`(`)^ C
lose()] method afterwards. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartPut`(const Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartPut]([@(0.0.255) const]_[_^Upp`:`:Stream^ Stream][@(0.0.255) `&
]_[*@3 in], [_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], [_^Upp`:`:int64^ int64]>_[*@3 pr
ogress]_`=_Null)&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Put`(const Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`)^ P
ut()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining. &]
[s2;%% [* Caution]: Object life time is a crucial parameter to take 
into account here. Do not let the calls to [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method outlive the [%-*@3 in][*  ]Stream. Otherwise your application 
will crash. &]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Put`(const Upp`:`:Stream`&`,const Upp`:`:String`&`,unsigned long`,long`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [@(0.0.255) b
ool]_[* Put]([@(0.0.255) const]_[_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 in], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[@(0.0.255) unsigned]_[@(0.0.255) long]_[*@3 flags], [@(0.0.255) long]_[*@3 mode], 
[_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], [_^Upp`:`:int64^ int64]>_[*@3 progress]_`=
_Null)&]
[s2;%% Overload. Uploads the local data at [%-*@3 in] to remote file 
at [%-*@3 path], with access [%-*@3 flags] and [%-*@3 mode]. Returns 
true on success. [%-*@3 progress ]function can be used to track 
the progress of the upload; returning true will abort the operation. 
Note that this overload manages (opens and closes) file handle 
internally. This method is blocking. &]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartPut`(const Upp`:`:Stream`&`,const Upp`:`:String`&`,unsigned long`,long`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartPut]([@(0.0.255) const]_[_^Upp`:`:Stream^ Stream][@(0.0.255) `&
]_[*@3 in], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[@(0.0.255) unsigned]_[@(0.0.255) long]_[*@3 flags], [@(0.0.255) long]_[*@3 mode], 
[_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], [_^Upp`:`:int64^ int64]>_[*@3 progress]_`=
_Null)&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Put`(const Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`)^ P
ut() ]overload. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining. &]
[s2;%% [* Caution]: Object life time is a crucial parameter to take 
into account here. Do not let the calls to [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method outlive the [%-*@3 in][*  ]Stream. Otherwise your application 
will crash. &]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Get`(Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [@(0.0.255) b
ool]_[* Get]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], [_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ i
nt64], [_^Upp`:`:int64^ int64]>_[*@3 progress]_`=_Null)&]
[s2;%% Downloads the remote file designated by the active file handle 
to local [%-*@3 out]. Returns true on success. [%-*@3 progress ]function 
can be used to track the progress of the download; returning 
true will abort the operation. Note that the file handle must 
be already allocated using [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Open`(const Upp`:`:String`&`,unsigned long`,long`)^ O
pen()] method, and it must be released using [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Close`(`)^ C
lose()] method afterwards. This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartGet`(Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartGet]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], 
[_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], [_^Upp`:`:int64^ int64]>_[*@3 progress]_`=
_Null)&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Get`(Upp`:`:Stream`&`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`)^ G
et()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining. &]
[s2;%% [* Caution]: Object life time is a crucial parameter to take 
into account here. Do not let the calls to [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method outlive the [%-*@3 out ]Stream. Otherwise your application 
will crash.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Get`(Upp`:`:Stream`&`,const Upp`:`:String`&`,unsigned long`,long`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [@(0.0.255) b
ool]_[* Get]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], [@(0.0.255) const]_[_^Upp`:`:String^ S
tring][@(0.0.255) `&]_[*@3 path], [@(0.0.255) unsigned]_[@(0.0.255) long]_[*@3 flags], 
[@(0.0.255) long]_[*@3 mode], [_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], 
[_^Upp`:`:int64^ int64]>_[*@3 progress]_`=_Null)&]
[s2;%% Overload. Downloads the remote file at [%-*@3 path] with access 
[%-*@3 flags] and [%-*@3 mode] to local [%-*@3 out]. Returns true on 
success. [%-*@3 progress ]function can be used to track the progress 
of the download; returning true will abort the operation. Note 
that this overload manages (opens and closes) file handle internally. 
This method is blocking.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:StartGet`(Upp`:`:Stream`&`,const Upp`:`:String`&`,unsigned long`,long`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`): [_^Upp`:`:SFtp^ S
Ftp][@(0.0.255) `&]_[* StartGet]([_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 path], 
[@(0.0.255) unsigned]_[@(0.0.255) long]_[*@3 flags], [@(0.0.255) long]_[*@3 mode], 
[_^Upp`:`:Gate^ Gate]<[_^Upp`:`:int64^ int64], [_^Upp`:`:int64^ int64]>_[*@3 progress]_`=
_Null)&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:Get`(Upp`:`:Stream`&`,const Upp`:`:String`&`,unsigned long`,long`,Upp`:`:Gate`<Upp`:`:int64`,Upp`:`:int64`>`)^ G
et()] overload. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining. &]
[s2;%% [* Caution]: Object life time is a crucial parameter to take 
into account here. Do not let the calls to [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method outlive the [%-*@3 out ]Stream. Otherwise your application 
will crash.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Seek`(Upp`:`:int64`): [@(0.0.255) bool]_[* Seek]([_^Upp`:`:int64^ int64
]_[*@3 position])&]
[s2;%% Seeks to [%-*@3 position] in a remote file.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:Tell`(`): [_^Upp`:`:int64^ int64]_[* Tell]()&]
[s2;%% Returns the current position from the beginning of a remote 
file in bytes.&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s3; &]
[s5;:Upp`:`:SFtp`:`:SFtp`(`): [* SFtp]()&]
[s2;%% Default constructor. In order for the SFtp instances constructed 
this way to be valid, they must be bound to a valid ssh session 
first, using [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:Session`(Upp`:`:Ssh`&`)^ S
ubsystem`::Session()] method. &]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:SFtp`(Upp`:`:Ssh`&`): [* SFtp]([_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[*@3 se
ssion])&]
[s2;%% Equivalent of the default constructor and then invoking [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:Session`(Upp`:`:Ssh`&`)^ S
ubsystem`::Session()]. Binds the SFtp instance to a given ssh 
[%-*@3 session]. Using this constructor is recommended.&]
[s3;%% &]
[s3; &]
[ {{10000@(113.42.0) [s0;%% [*@7;4 SFtp`::DirEntry]]}}&]
[s0;%% &]
[s1;:Upp`:`:SFtp`:`:DirEntry`:`:class: [@(0.0.255)3 class][3 _][*3 DirEntry][3 _:_][@(0.0.255)3 p
rivate][3 _][*@3;3 Moveable][3 <][*3 DirEntry][3 >_]&]
[s2;%% This nested helper class is intended to simplify the parsing 
of directory entries (files, directories, symbolic links) returned 
by the [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:class^ SFtp] 
class.&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Method List]]}}&]
[s3;%% &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:GetName`(`)const: [_^Upp`:`:String^ String]_[* GetName]()
_[@(0.0.255) const]&]
[s2;%% Returns the name (path) of the entry.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:GetEntry`(`)const: [_^Upp`:`:String^ String]_[* GetEntry](
)_[@(0.0.255) const]&]
[s2;%% Returns the directory listing string of the entry. (Usually 
in traditional UNIX style.)&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:GetUid`(`)const: [_^Upp`:`:int64^ int64]_[* GetUid]()_[@(0.0.255) c
onst]&]
[s2;%% Returns the user id associated with the entry.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:GetGid`(`)const: [_^Upp`:`:int64^ int64]_[* GetGid]()_[@(0.0.255) c
onst]&]
[s2;%% Returns the group id associated with the entry.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:GetSize`(`)const: [_^Upp`:`:int64^ int64]_[* GetSize]()_[@(0.0.255) c
onst]&]
[s2;%% Returns the size of the entry in bytes. Returns `-1 on failure.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:GetLastModified`(`)const: [_^Upp`:`:Time^ Time]_[* GetLas
tModified]()_[@(0.0.255) const]&]
[s2;%% Returns the last modification time of the entry.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:GetLastAccessed`(`)const: [_^Upp`:`:Time^ Time]_[* GetLas
tAccessed]()_[@(0.0.255) const]&]
[s2;%% Returns the last access time of the entry.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:GetAttrs`(`): [_^Upp`:`:SFtpAttrs^ SFtpAttrs][@(0.0.255) `&
]_[* GetAttrs]()&]
[s2;%% Returns the libssh2 file attributes structure for the entry.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsFile`(`)const: [@(0.0.255) bool]_[* IsFile]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the entry is a file.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsDirectory`(`)const: [@(0.0.255) bool]_[* IsDirectory]()
_[@(0.0.255) const]&]
[s2;%% Returns true if the entry is a directory.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsSymLink`(`)const: [@(0.0.255) bool]_[* IsSymLink]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the entry is a symbolic link.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsSpecial`(`)const: [@(0.0.255) bool]_[* IsSpecial]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the entry is a character special file.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsBlock`(`)const: [@(0.0.255) bool]_[* IsBlock]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the entry is a block special file.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsFifo`(`)const: [@(0.0.255) bool]_[* IsFifo]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the entry is a FIFO special file.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsSocket`(`)const: [@(0.0.255) bool]_[* IsSocket]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the entry is a socket.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsReadable`(`)const: [@(0.0.255) bool]_[* IsReadable]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the entry is readable.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsWriteable`(`)const: [@(0.0.255) bool]_[* IsWriteable]()
_[@(0.0.255) const]&]
[s2;%% Returns true if the entry is writeable.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsReadOnly`(`)const: [@(0.0.255) bool]_[* IsReadOnly]()_[@(0.0.255) c
onst]&]
[s2;%% Returns true if the entry is read`-only.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:IsExecutable`(`)const: [@(0.0.255) bool]_[* IsExecutable](
)_[@(0.0.255) const]&]
[s2;%% Returns true if the entry is executable.&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s3; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:DirEntry`(`): [* DirEntry]()&]
[s2;%% Default consturtor.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirEntry`:`:DirEntry`(const Upp`:`:Nuller`&`): [* DirEntry]([@(0.0.255) c
onst]_[_^Upp`:`:Nuller^ Nuller][@(0.0.255) `&])&]
[s2;%% Nuller for the DirEntry class.&]
[s0; &]
[ {{10000@(113.42.0) [s0;%% [*@7;4 SFtp`::DirList]]}}&]
[s4; &]
[s5;:Upp`:`:SFtp`:`:DirList`:`:typedef: [@(0.0.255) typedef]_[_^Upp`:`:Vector^ Vector]<[_^Upp`:`:SFtp`:`:DirEntry^ D
irEntry]>_[* DirList]&]
[s2;%% SFtp`::DirList is a [^topic`:`/`/Core`/src`/Vector`$en`-us`#Vector`:`:class^ Vect
or ]type container, containing [^topic`:`/`/SSH`/src`/Ssh`_SFtp`$en`-us`#Upp`:`:SFtp`:`:DirEntry`:`:class^ S
Ftp`::DirEntry] elements.&]
[s3; &]
[s0;%% ]]